﻿
function LoadCssStyleset(UrlCss)
{
    var txtFile = CreateHttpRequest();
    txtFile.onreadystatechange = function()
    {
        if (txtFile.readyState == 4)
        {
            if (txtFile.status == 200)
            {
                CKEDITOR.config.stylesCombo_stylesSet = GenerateStyleSet(txtFile.responseText, 'Add-to-combobox:');
            }
        }
    }

    txtFile.open("GET", UrlCss, true);
    txtFile.send(null);
}

function GetParam(Data, ParamName, DefaultValue)
{
    Data = " " + Data + " ";

    if (ParamName == "")
        return DefaultValue;

    i_Pos = Data.indexOf(" " + ParamName + "=");

    if (i_Pos < 0)
        return DefaultValue;

    i_Pos = i_Pos + ParamName.length + 2;
    c_StopChar = ' ';
    if (Data.charAt(i_Pos) == '"' || Data.charAt(i_Pos) == '\'')
    {
        c_StopChar = Data.charAt(i_Pos);
        i_Pos++;
    }

    s_Result = "";
    for (var i = i_Pos; i < Data.length; i++)
    {
        if (Data.charAt(i) == c_StopChar)
            break;
        s_Result = s_Result + Data.charAt(i);
    }
    // alert("GetParam('" + Data + "', '" + ParamName + "', '" + DefaultValue + "') => '" + s_Result + "'");

    if (s_Result.length > 0)
        return s_Result;

    return DefaultValue;
}

function AddToStyleList(StylesSet, StyleName, MarkedWithComment)
{
    // don't add ID based
    if (StyleName.indexOf('#') >= 0)
        return false;

    var as_Parts = StyleName.split('/*');
    // needs to be marked by a keyword in the comment, but this line doesn't even have a comment
    if (MarkedWithComment.length > 0 && as_Parts.length == 1)
        return false;

    StyleName = trim(as_Parts[0]);
    s_Comment = "";
    if (as_Parts.length > 1)
        s_Comment = as_Parts[1];

    // needs to be marked by a keyword in the comment, but this comment doesn't contain the keyword
    if (MarkedWithComment.length > 0 && s_Comment.indexOf(MarkedWithComment) < 0)
        return false;

    s_TagName = "";
    s_ClassName = "";
    s_DisplayName = StyleName;

    as_Parts = StyleName.split('.');

    if (as_Parts.length > 1)
    {
        s_TagName = trim("" + as_Parts[0]);
        s_ClassName = trim("" + as_Parts[1]);
    }
    else
    {
        s_TagName = StyleName;
        s_ClassName = StyleName;
    }

    // inside the comment an alternative 'element' or 'name' may be specified
    s_DisplayName = GetParam(s_Comment, 'name', s_DisplayName);

    if (s_TagName == "")
        s_TagName = GetParam(s_Comment, 'element', s_TagName);

    if (s_TagName == "")
        s_TagName = "span"; // default tag name

    /*alert("[" + StyleName + "] as_Parts.length: " + as_Parts.length
    + "\r\ns_TagName: " + s_TagName
    + "\r\ns_ClassName: " + s_ClassName
    + "\r\ns_DisplayName: " + s_DisplayName);*/

    StylesSet.push({
        name: s_DisplayName,
        element: s_TagName,
        attributes: { 'class': s_ClassName }
    });

    return true;
}

function GenerateStyleSet(CssText, MarkedWithComment)
{
    var MyStylesSet = new Array();
    var s_StyleNameLines = "";

    var as_Lines = CssText.split('{');
    for (var i = 0; i < as_Lines.length; i++)
    {
        var as_LineBrokenAgain = as_Lines[i].split("}");
        s_StyleNameLine = "";

        if (as_LineBrokenAgain.length > 1)
            s_StyleNameLine = trim(as_LineBrokenAgain[1]);
        else
            s_StyleNameLine = trim(as_Lines[i]);

        var as_StyleNames = s_StyleNameLine.split(',');
        for (var u = 0; u < as_StyleNames.length; u++)
        {
            if (AddToStyleList(MyStylesSet, trim(as_StyleNames[u]), MarkedWithComment))
            {
                s_StyleNameLines = s_StyleNameLines + "\r\n : " + as_StyleNames[u];
            }
        }

    }

    return MyStylesSet;
}


function trim(text)
{
    if (text == null)
        return null;

    return text.replace(/^(\s+)?(.*\S)(\s+)?$/, '$2')
}

function UrlPath()
{
    var s_Result = document.location.href;
    s_Result = s_Result.substring(0, s_Result.lastIndexOf('/'));
    return s_Result + '/';
}

function CreateHttpRequest()
{
    var request = null;
    if (typeof window.XMLHttpRequest != 'undefined')
    {
        request = new XMLHttpRequest();
    }
    else if (typeof window.ActiveXObject != 'undefined')
    {
        // try {
        request = new ActiveXObject('Microsoft.XMLHTTP');
        // } catch(err) { request = null; } 
    }

    return request;
}