// Written by Daniel Cohen Gindi danielgindi@gmail.com

using System ;
using System.Collections ;
using System.Runtime.Serialization ;

namespace FredCK.CKEditor
{
	[ Serializable() ]
	public class CKEditorConfigurations : ISerializable
	{
		private Hashtable _Configs ;

		internal CKEditorConfigurations()
		{
			_Configs = new Hashtable() ;
		}

        protected CKEditorConfigurations(SerializationInfo info, StreamingContext context)
		{
			_Configs = (Hashtable)info.GetValue( "ConfigTable", typeof( Hashtable ) ) ;
		}

		public string this[ string configurationName ]
		{
			get
			{
				if ( _Configs.ContainsKey( configurationName ) )
					return (string)_Configs[ configurationName ] ;
				else
					return null ;
			}
			set
			{
				_Configs[ configurationName ] = value ;
			}
		}

        public bool Remove(string configurationName)
        {
            if (_Configs.ContainsKey(configurationName))
                _Configs.Remove(configurationName);
            else return false;
            return true;
        }

		internal string GetJsConfigArray()
		{
			System.Text.StringBuilder osParams = new System.Text.StringBuilder() ;

			foreach ( DictionaryEntry oEntry in _Configs )
			{
				if ( osParams.Length > 0 )
					osParams.Append( "," ) ;

				osParams.AppendFormat( "{0}: {1}", oEntry.Key.ToString(), oEntry.Value.ToString() ) ;
			}

			return osParams.ToString() ;
		}

        #region ISerializable Members

        public void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
        {
            info.AddValue("ConfigTable", _Configs);
        }

        #endregion
	}
}
